/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edid.compare;

import com.quantumdata.std.IQDConsole;
import com.quantumdata.std.IRemoteConnection;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.SocketConnection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EdidCompare
extends JApplet
implements IQDConsole {
    private static final long serialVersionUID = 1L;
    private RemoteInstrument m_instrument;
    private JTextField m_refName;
    private JTextField m_results;
    private RefAction m_refAction;
    private CompareAction m_compAction;
    private String m_refEdid;
    private String m_edid;
    private int m_capCnt = 1;

    public void init() {
        this.create("");
    }

    public void create(String string) {
        Object object;
        if (string.equals("")) {
            try {
                object = this.getCodeBase();
                string = ((URL)object).getHost();
            }
            catch (NullPointerException nullPointerException) {
                string = this.getNewIP();
            }
        }
        object = new SocketConnection(string);
        this.m_instrument = new RemoteInstrument((IRemoteConnection)object, this);
        Font font = new Font("Monospaced", 1, 16);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Capture Reference To: "));
        jPanel2.add(new JButton(new BrowseAction()));
        jPanel.add((Component)jPanel2, "North");
        this.m_refName = new JTextField("RefEdid.xml");
        jPanel.add((Component)this.m_refName, "South");
        container.add((Component)jPanel, "North");
        jPanel = new JPanel(new BorderLayout());
        this.m_refAction = new RefAction();
        this.m_compAction = new CompareAction();
        this.m_compAction.setEnabled(false);
        this.m_results = new JTextField();
        this.m_results.setEditable(false);
        this.showMsg("No Data");
        this.m_results.setFont(font);
        this.m_results.setBackground(Color.DARK_GRAY);
        this.m_results.setHorizontalAlignment(0);
        jPanel2 = new JPanel();
        jPanel2.add(new JButton(this.m_refAction));
        jPanel2.add(new JLabel("      "));
        jPanel2.add(new JButton(this.m_compAction));
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.m_results, "Center");
        container.add((Component)jPanel, "Center");
    }

    public void start() {
        try {
            this.m_instrument.connect();
        }
        catch (InstrumentException instrumentException) {
            JOptionPane.showMessageDialog(this, "*** CONNECTION FAILED: " + instrumentException.getMessage() + " ***");
            this.showError("No Connection");
            return;
        }
    }

    public void stop() {
        this.m_instrument.disconnect();
    }

    protected String getNewIP() {
        String string = JOptionPane.showInputDialog(this, "Enter an IP Address:", "Connect to?", 3);
        if (string == null) {
            return "";
        }
        if (string instanceof String) {
            String string2 = string;
            return string2;
        }
        return "";
    }

    public void println(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        EdidCompare edidCompare = new EdidCompare();
        JFrame jFrame = new JFrame("Edid Compare: ");
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(edidCompare);
        jFrame.setSize(400, 600);
        edidCompare.create("");
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setLocationRelativeTo(null);
        edidCompare.start();
    }

    private void compareEdids() {
        if (this.m_refEdid.compareTo(this.m_edid) == 0) {
            this.showMsg("The EDID's Matched");
        } else {
            this.showError("Mis-Matched EDID's: ");
        }
    }

    private void saveEdid(String string, boolean bl) {
        int n;
        String string2 = this.m_refName.getText();
        if (bl && (n = this.m_refName.getText().lastIndexOf(46)) > 0) {
            string2 = this.m_refName.getText().substring(0, n) + "_Compare_" + this.m_capCnt + this.m_refName.getText().substring(n);
            ++this.m_capCnt;
        }
        File file = new File(string2);
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n");
            fileWriter.write("<DATAOBJ>\r\n");
            fileWriter.write("  <HEADER TYPE=\"DID\" VERSION=\"1.0\" ></HEADER>\r\n");
            fileWriter.write("  <DATA>\r\n");
            int n2 = string.length();
            for (int i = 0; i < 4; ++i) {
                fileWriter.write("    <BLOCK" + i + ">");
                if (n2 >= i * 256 + 256) {
                    fileWriter.write(string.substring(i * 256, i * 256 + 256));
                }
                fileWriter.write("</BLOCK" + i + ">\r\n");
            }
            fileWriter.write("  </DATA>\r\n");
            fileWriter.write("</DATAOBJ>\r\n");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            this.showError(iOException.getMessage());
            return;
        }
    }

    private void showMsg(String string) {
        this.m_results.setForeground(Color.GREEN);
        this.m_results.setText(string);
    }

    private void showError(String string) {
        this.m_results.setForeground(Color.RED);
        this.m_results.setText(string);
    }

    class CompareAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CompareAction() {
            super("Compare to Reference");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InstrumentResponse instrumentResponse = EdidCompare.this.m_instrument.sendCmd("EDID?");
            if (instrumentResponse.isError()) {
                EdidCompare.this.showError(instrumentResponse.getResponse());
                return;
            }
            EdidCompare.this.m_edid = instrumentResponse.getResponse();
            EdidCompare.this.compareEdids();
            EdidCompare.this.saveEdid(EdidCompare.this.m_edid, true);
        }
    }

    class RefAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public RefAction() {
            super("Capture Reference");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InstrumentResponse instrumentResponse = EdidCompare.this.m_instrument.sendCmd("EDID?");
            if (instrumentResponse.isError()) {
                EdidCompare.this.showError("Error: " + instrumentResponse.getResponse());
                return;
            }
            EdidCompare.this.m_refEdid = instrumentResponse.getResponse();
            EdidCompare.this.showMsg("Reference Successfully Captured");
            EdidCompare.this.m_compAction.setEnabled(true);
            EdidCompare.this.saveEdid(EdidCompare.this.m_refEdid, false);
        }
    }

    class BrowseAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public BrowseAction() {
            super("Browse");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setSelectedFile(new File(EdidCompare.this.m_refName.getText()));
            if (jFileChooser.showSaveDialog(EdidCompare.this) == 0) {
                EdidCompare.this.m_refName.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                EdidCompare.this.m_capCnt = 1;
            }
        }
    }
}

